﻿//////////////////////////////////////////////
// CompositorManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class RenderContext ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Compositor.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <mutex>
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkGraphics
{	
	class DLL_GRAPHICS_EXPORT CompositorManager final : public Manager<Compositor>, public nkCommon::MaybeSingletonClass<CompositorManager>
	{
		public :

			// Getters
			Compositor* getActiveCompositor () const ;
			Compositor* getDefaultCompositor () const ;

			// Setters
			void setActiveCompositor (Compositor* compositor) ;
			void setDefaultCompositor (Compositor* compositor) ;

			// Context management
			void prepareForContext (RenderContext* context) ;

		private :

			// Constructor, destructor
			CompositorManager (bool isSingleton) noexcept ;
			CompositorManager (System* system) noexcept ;

		private :
		
			// Attributes
			// States
			Compositor* _activeCompositor ;
			Compositor* _defaultCompositor ;

		private :

			friend class nkCommon::MaybeSingletonClass<CompositorManager> ;
			friend class System ;
	} ;
}